RequireScript("datatools.js");
RequireSystemScript("colors.js");

function Zylia(id,loc,ipath){
	this.ID=id;
	this.active=false;
	this.save_ability=false;
	this.hp_restore_ability=false;
	this.mp_restore_ability=false;
	this.teleport_ability=false;
	this.location_name=loc;
	this.saveImagePath=ipath
	}
	

function ZyliaSystem(){
	
	this.active_zylias=createFalseArray(100);
	this.save_zylias=createFalseArray(100);
	this.hp_zylias=createFalseArray(100);
	this.mp_zylias=createFalseArray(100);
	this.teleport_zylias=createFalseArray(100);
	
	//setup special zylia states
	
		//Zylia 0
	
		//Zylia 1
			this.save_zylias[1]=true;
			this.active_zylias[1]=true;
	
		//Zylia 2
			this.save_zylias[2]=true;
			
		//Zylia 3
	
		//Zylia 4
	
		//Zylia n
	
	//finished setup
	
	this.get = function(id){
		langmodule.setMode("zylialist");
		switch (id){
			
			case 0:var tmpzylia=new Zylia(id,langmodule.getString("Z_0000_L"),"story/ci_kiltos01.jpg");break;
			case 1:var tmpzylia=new Zylia(id,langmodule.getString("Z_0001_L"),"story/ci_kiltos02.jpg");break;
			case 2:var tmpzylia=new Zylia(id,langmodule.getString("Z_0002_L"),"story/ci_kiltos01.jpg");break;
			}
		tmpzylia.active=this.active_zylias[id];
		tmpzylia.save_ability=this.save_zylias[id];
		tmpzylia.hp_restore_ability=this.hp_zylias[id];
		tmpzylia.mp_restore_ability=this.mp_zylias[id];
		tmpzylia.teleport_ability=this.teleport_zylias[id];
		langmodule.setLastMode();
		return(tmpzylia);
		}
}

ZyliaSystem.prototype.save = function (file){
	
	file.write(this.active_zylias.length);
	for(var i=0;i<this.active_zylias.length;i++)file.write(this.active_zylias[i]?1:0);
	
	file.write(this.save_zylias.length);
	for(var i=0;i<this.save_zylias.length;i++)file.write(this.save_zylias[i]?1:0);
	
	file.write(this.hp_zylias.length);
	for(var i=0;i<this.hp_zylias.length;i++)file.write(this.hp_zylias[i]?1:0);
	
	file.write(this.mp_zylias.length);
	for(var i=0;i<this.mp_zylias.length;i++)file.write(this.mp_zylias[i]?1:0);
	
	file.write(this.teleport_zylias.length);
	for(var i=0;i<this.teleport_zylias.length;i++)file.write(this.teleport_zylias[i]?1:0);
	
	}
	
ZyliaSystem.prototype.load = function (file){
	
	var zylianumber = file.readInt();
	for(var i=0;i<zylianumber;i++)this.active_zylias[i]=(file.readInt()==1);
	
	var zylianumber = file.readInt();
	for(var i=0;i<zylianumber;i++)this.save_zylias[i]=(file.readInt()==1);
	
	var zylianumber = file.readInt();
	for(var i=0;i<zylianumber;i++)this.hp_zylias[i]=(file.readInt()==1);
	
	var zylianumber = file.readInt();
	for(var i=0;i<zylianumber;i++)this.mp_zylias[i]=(file.readInt()==1);
	
	var zylianumber = file.readInt();
	for(var i=0;i<zylianumber;i++)this.teleport_zylias[i]=(file.readInt()==1);
		
	}


var zyliasystem=new ZyliaSystem();

/*//////////////////////////////////////////////////////////
GLOBAL ZYLIA FUNCTIONS<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
///////////////////////////////////////////////////////////*/

function TryGenerateZylia(id){
	
	if(id>=zyliasystem.active_zylias.length)return;
	
	if(zyliasystem.active_zylias[id]){
		//SetPersonSpriteset(name, spriteset)
		SetPersonFrame(GetCurrentPerson(),1);
		}
	else{
		//SetPersonSpriteset(name, spriteset)
		SetPersonFrame(GetCurrentPerson(),0);
		}
	}
	

function ZyliaMenu(zylia_id){
	enemysystem.pause = true;
	personcontroller.lockAllInputProfile(true,undefined);
	var attper=g_lastTalker;
	var curper=GetCurrentPerson();
	var tmpzylia=zyliasystem.get(zylia_id);
	
	
	//reset input
	while(IsAnyKeyPressed());
	ClearKey();
	
	//build menuoptions
	langmodule.setMode("system");
	var tmpmenuoptions=[];
	var tmpmenupointcounter=0;
	tmpmenuoptions[tmpmenupointcounter++]=[
										objectsystem.image.get("icons/zyliamenu/zm_give_01.png"),
										objectsystem.image.get("icons/zyliamenu/zm_give_02.png"),
										langmodule.getString("S_ZYLIA_GIVE"),
										0,
										function(){
											ZyliaItemMenu(zylia_id,curper);
											}
										];
	
	tmpmenuoptions[tmpmenupointcounter++]=[
										objectsystem.image.get("icons/zyliamenu/zm_status_01.png"),
										objectsystem.image.get("icons/zyliamenu/zm_status_02.png"),
										langmodule.getString("S_ZYLIA_STATUS"),
										0,
										function(){
											ZyliaStatusMenu(zylia_id);
											}
										];
											
	if(tmpzylia.active){
	
		if(tmpzylia.save_ability){
			tmpmenuoptions[tmpmenupointcounter++]=[
										objectsystem.image.get("icons/zyliamenu/zm_save_01.png"),
										objectsystem.image.get("icons/zyliamenu/zm_save_02.png"),
										langmodule.getString("S_ZYLIA_SAVE"),
										0,
										function(){
											g_saveStateZyliaID = tmpzylia.ID;
											FileDialog(GrabImage(0,0,GetScreenWidth(),GetScreenHeight()),true);
											}
										];
			}
		
		
		
		}
	
	langmodule.setLastMode();
	
	
	var tmpexit=false;
	
	var tmpstep=360/tmpmenuoptions.length;
	var tmpmenuangle=359;
	var tmpcursor=0;
	var tmpmenusize=0;
	var tmpaimed_menusize=100;
	var tmpmenupos = new Point2(
									Math.min(Math.max(MapToScreenX(GetPersonLayer(curper),GetPersonX(curper)),tmpaimed_menusize),GetScreenWidth()-tmpaimed_menusize),
									Math.min(Math.max(MapToScreenY(GetPersonLayer(curper),GetPersonY(curper)),tmpaimed_menusize),GetScreenHeight()-tmpaimed_menusize)
									);
	var y_scale=0.5;
	var x_scale=1;
	var img_width_half=0;
	var img_height_half=0;
	var win_img_width_half=objectsystem.image.get("menu/zylia_menu.png").width/2;
	var win_img_height_half=objectsystem.image.get("menu/zylia_menu.png").height/2;
	var tmpcolorwhite= CreateColor(255,255,255,255);
	var lastBlit = false;
	while(!tmpexit||Math.round(tmpmenusize)!=0){
		
		UpdateMapEngine();
		RenderMap();
		
		objectsystem.image.get("menu/zylia_menu.png").blit(tmpmenupos.x-win_img_width_half,tmpmenupos.y-win_img_height_half);
		
		for(var i=0;i<tmpmenuoptions.length;i++){
			img_width_half=tmpmenuoptions[i][1].width/2;
			img_height_half=tmpmenuoptions[i][1].height/2;
			tmpcolorwhite.alpha=tmpmenuoptions[i][3];
			tmpmenuoptions[i][3]=Math.min(255,Math.max(0,tmpmenuoptions[i][3]+((i==tmpcursor)?10:-10)));
			cfont.setColorMask(tmpcolorwhite);
			cfont.drawText(tmpmenupos.x-cfont.getStringWidth(tmpmenuoptions[i][2])/2,tmpmenupos.y-cfont.getHeight()/2,tmpmenuoptions[i][2]);
			if(i==tmpcursor&&GetTime()%1000>500){
				tmpmenuoptions[i][1].blit(
					tmpmenupos.x+Math.cos((tmpmenuangle-90+i*tmpstep)*Math.PI/180)*tmpmenusize*x_scale-img_width_half,
					tmpmenupos.y+Math.sin((tmpmenuangle-90+i*tmpstep)*Math.PI/180)*tmpmenusize*y_scale-img_height_half
					);
				}
			else{
				tmpmenuoptions[i][0].blit(
					tmpmenupos.x+Math.cos((tmpmenuangle-90+i*tmpstep)*Math.PI/180)*tmpmenusize*x_scale-img_width_half,
					tmpmenupos.y+Math.sin((tmpmenuangle-90+i*tmpstep)*Math.PI/180)*tmpmenusize*y_scale-img_height_half
					);
				}
		
			}
		

		tmpmenuangle+=((((tmpmenuoptions.length-tmpcursor)*tmpstep)%360)-tmpmenuangle)/5;
		tmpmenusize+=((tmpaimed_menusize)-tmpmenusize)/5;
		if(AreKeysLeft()){
			switch(GetKey()){
				case btn_RIGHT:{
					if(tmpcursor==0)tmpmenuangle+=360
					tmpcursor++;
					if(tmpcursor>=tmpmenuoptions.length){
						tmpcursor=0;
						}
					
					
					break;
					}
				case btn_LEFT:{
					if(tmpmenuoptions.length==1)tmpmenuangle-=360;
					if(tmpcursor==1)tmpmenuangle-=360;
					tmpcursor--;
					if(tmpcursor<0){
						tmpcursor=tmpmenuoptions.length-1;
						}
					break;
					}
				case btn_OK:{
					tmpmenuoptions[tmpcursor][4]();
					tmpaimed_menusize=0;
					tmpexit=true;
					lastBlit=true;
					break;
					}
				case btn_CANCEL:{
					tmpaimed_menusize=0;
					tmpexit=true;
					break;
					}
				}
			ClearKey();
			}
		if(!lastBlit)FlipScreenFps();
		else lastBlit=false;
	}
	
	FlashMap(CreateColor(255,255,255,100),0,10);
	MapDelay(10)
	while(IsAnyKeyPressed());
	ClearKey();
	personcontroller.lockAllInputProfile(false,undefined);
	enemysystem.pause = false;
}


function ZyliaItemMenu(zylia_id,person){
	

	var tmpzylia=zyliasystem.get(zylia_id);
	
	var tmpexit=false;
	var tmpbgalpha=0;
	var tmpbgclr=CreateColor(255,255,255,0);
	var tmpbgimg=objectsystem.image.get("icons/zyliamenu/zylia_raise_bg.png");
	
	var tmpimg=GrabImage(0,0,GetScreenWidth(),GetScreenHeight());
	
	menubg_s(255);
	var tmpkaro=GrabImage(0,0,GetScreenWidth(),GetScreenHeight());
	
	for(var i=0;i<200;i+=40){
		tmpimg.blit(0,0);
		tmpbgclr.alpha=i/2;
		tmpkaro.blitMask(0,0,tmpbgclr);
		tmpbgclr.alpha=i;
		tmpbgimg.blitMask(0,0,tmpbgclr);
		FlipScreenFps();
	}
	
	tmpimg.blit(0,0);
	tmpkaro.blitMask(0,0,tmpbgclr);
	tmpbgimg.blitMask(0,0,tmpbgclr);
	
	windowm.drawWindow(250,250,350,font.getHeight()*5+10);
	windowm.drawWindow(250,260+font.getHeight()*5+20,350,font.getHeight()*3+10); 
	Rectangle(0,100,GetScreenWidth(),font.getHeight()+10,CreateColor(0,0,0,180));
	
	tmpbg=GrabImage(0,0,GetScreenWidth(),GetScreenHeight());
	
	//tmpimg=ComputeBackground(1,1,tmpimg,true);

	
	//reset input
	while(IsAnyKeyPressed());
	ClearKey();
	
	//build menuoptions
	
	var tmpmenuoptions=[];
	var tmpitem = undefined;
	
		
	//Add No_4 for saving if >0
	tmpitem = objectsystem.items.get(4);
	if(tmpitem.menge>0)tmpmenuoptions.push([tmpitem.name,tmpitem.menge,tmpitem.icon,
			function (){
				objectsystem.items.get(4).menge--;
				objectsystem.items.updateCache();
				zyliasystem.save_zylias[zylia_id]=true;	
				zyliasystem.active_zylias[zylia_id]=true;
				TryGenerateZylia(zylia_id);
				},
			tmpitem.kubeschr
			]
		);
	
	var tmptext=0;
	langmodule.setMode("system");
	var texts=langmodule.getString("S_ZYLIA_ITEM_HELP");
	var txt_notitems=langmodule.getString("S_NOITEMS");
	langmodule.setLastMode();
	
	
	
	var cursor=0;
	var select=0;
	var tmpv=0;
	var tmpa=true;
	
	while(!tmpexit){
		
		if(tmpa){
			tmpv+=0.5;
			}
		else{
			tmpv-=0.5;
			}
		if(tmpv==3)tmpa=false;
		if(tmpv==-3)tmpa=true;
		
		tmpbg.blit(0,0);
		
		font.drawText(GetScreenWidth()-tmptext,105,texts);
		if(tmptext++ > font.getStringWidth(texts)+GetScreenWidth())tmptext=0;
		
		
			
		
		
		if(tmpmenuoptions.length==0){
			font.drawText(270,255,txt_notitems);
			}
		else{
			
			scrollbar(true,250,250,350,font.getHeight()*5+10,select,5,tmpmenuoptions.length,font.getHeight());
				
			for(var i=select;i<tmpmenuoptions.length;i++){
				tmpmenuoptions[i][2].blit(260,255+(i-select)*font.getHeight());
				font.drawText(280,255+(i-select)*font.getHeight(),tmpmenuoptions[i][0]);
				font.drawText(550,255+(i-select)*font.getHeight(),"x "+tmpmenuoptions[i][1]);
				font.drawTextBox(255,260+font.getHeight()*5+25,340,font.getHeight()*3,0,tmpmenuoptions[i][0]+"      x "+tmpmenuoptions[i][1]+"\n"+tmpmenuoptions[i][4]);
				}
			
			GlobalCursor.setPos(230,255+font.getHeight()*cursor);
			GlobalCursor.blit(tmpv,0);
			
			}
		
		
		
		
		if(AreKeysLeft()){
			switch(GetKey()){
				case btn_UP:{
					if(cursor+select>0)cursor--
					if(cursor<0){
						cursor++;
						select--;
						}
					break;
					}
				case btn_DOWN:{
					if(cursor+select<tmpmenuoptions.length-1)cursor++;
					if(cursor>5){
						cursor--;
						select++;
						}
					break;
					}
				case btn_OK:{
					if(tmpmenuoptions.length>0)tmpmenuoptions[cursor+select][3]();
					tmpexit=true;
					break;
					}
				case btn_CANCEL:{
					
					tmpexit=true;
					break;
					}
				}
			ClearKey();
			}
		FlipScreenFps();		
	}
	for(var i=200;i>0;i-=40){
		tmpimg.blit(0,0);
		tmpbgclr.alpha=i/2;
		tmpkaro.blitMask(0,0,tmpbgclr);
		tmpbgclr.alpha=i;
		tmpbgimg.blitMask(0,0,tmpbgclr);
		FlipScreenFps();
	}
	tmpimg.blit(0,0);
	tmpkaro.blitMask(0,0,tmpbgclr);
	tmpbgimg.blitMask(0,0,tmpbgclr);
	while(IsAnyKeyPressed());
	ClearKey();
	
}

function ZyliaStatusMenu(zylia_id){
	

	var tmpzylia=zyliasystem.get(zylia_id);
	
	tmpimg=ComputeBackground(1,1,GrabImage(0,0,GetScreenWidth(),GetScreenHeight()),true);
	
	//reset input
	while(IsAnyKeyPressed());
	ClearKey();
	
	//build strings
	
	langmodule.setMode("system");
	
	var tmp_strings=[
									langmodule.getString("S_ZYLIA_OVER_1"),
									langmodule.getString("S_ZYLIA_OVER_2"),
									langmodule.getString("S_ZYLIA_ACTIVE"),
									langmodule.getString("S_ZYLIA_INACTIVE"),
									langmodule.getString("S_ZYLIA_INFO_ACTIVE"),
									langmodule.getString("S_ZYLIA_INFO_INACTIVE"),
									langmodule.getString("S_ZYLIA_ABILITY_SAVE"),
									langmodule.getString("S_ZYLIA_INFO_SAVE")
									];
	var texts=langmodule.getString("S_ZYLIA_INFO_STATUS");
	langmodule.setLastMode();
	
	var counter=0;
	var cursor = 0;
	var tmp_infostr=[];
	
	windowm.drawWindow(300,80,300,font.getHeight()*3+10);
		
	//windowm.drawWindow(300,60,300,font.getHeight()*3);
	//windowm.drawWindow(300,60,300,font.getHeight()*3);
	//windowm.drawWindow(300,60,300,font.getHeight()*3);
	
	if(tmpzylia.active){
		font.drawTextBox(305,85,290,font.getHeight()*3,0,tmp_strings[4]);	
		
		}
	else{
		font.drawTextBox(305,85,290,font.getHeight()*3,0,tmp_strings[5]);	
		
		}
	
	
	if(tmpzylia.save_ability){
		windowm.drawWindow(300,160+counter*(font.getHeight()+30),300,font.getHeight()+10);
		objectsystem.image.get("icons/zyliamenu/zm_save_01.png").blit(305,158+counter*(font.getHeight()+30));
		font.drawText(340,165+counter*(font.getHeight()+30),tmp_strings[6]);
		tmp_infostr.push(tmp_strings[7]);
		counter++;
		}
	
	
	if(counter>0){
		windowm.drawWindow(40,GetScreenHeight()-(font.getHeight()*3+20),560,font.getHeight()*3+10);
		Rectangle(0,GetScreenHeight()-(font.getHeight()*4+50),GetScreenWidth(),font.getHeight()+10,CreateColor(0,0,0,180));
		}
	
	var tmptxt= tmp_strings[0]+": "+tmpzylia.location_name+" - "+tmp_strings[1]+": "+counter+" - "+(tmpzylia.active ? tmp_strings[2] : tmp_strings[3]);
	Rectangle(0,30,GetScreenWidth(),font.getHeight()+10,CreateColor(0,0,0,180));
	font.drawText(GetScreenWidth()/2-font.getStringWidth(tmptxt)/2,35,tmptxt);
	
	
	
	
	tmpimg=GrabImage(0,0,GetScreenWidth(),GetScreenHeight());
	var tmpexit=false;
	var tmptextpos=0;
	
	var tmpv=0;
	var tmpa=true;
	
	while(!tmpexit){
		
		if(tmpa){
			tmpv+=0.5;
			}
		else{
			tmpv-=0.5;
			}
		if(tmpv==3)tmpa=false;
		if(tmpv==-3)tmpa=true;
		
		tmpimg.blit(0,0);
		if(counter>0){
			font.drawText(GetScreenWidth()-tmptextpos,GetScreenHeight()-(font.getHeight()*4+45),texts);
			if(tmptextpos++ > font.getStringWidth(texts)+GetScreenWidth())tmptextpos=0;
			
			font.drawTextBox(45,GetScreenHeight()-(font.getHeight()*3+15),550,font.getHeight()*3,0,tmp_infostr[cursor]);
			
			GlobalCursor.setPos(275,165+cursor*(font.getHeight()+30));
			GlobalCursor.blit(tmpv,0);
			}
				
			
		
		if(AreKeysLeft()){
			switch(GetKey()){
				case btn_UP:{
					if(cursor>0)cursor--
					break;
					}
				case btn_DOWN:{
					if(cursor<counter-1)cursor++;
					break;
					}
				case btn_OK:
				case btn_CANCEL:{
					tmpexit=true;
					break;
					}
				}
			ClearKey();
			}
		FlipScreenFps();		
	}
	
	while(IsAnyKeyPressed());
	ClearKey();
	
}


/*/////////////////
function TryGenerateBox(id){
	if(g_Boxes.open[id]){
		SetPersonFrame(GetCurrentPerson(),1);
		}
	else{
		SetPersonFrame(GetCurrentPerson(),0);
		}
	}
	
function TryOpenBox(id){
	personcontroller.lockAllInputProfile(true,undefined);
	langmodule.setMode("system");
	var attper=g_lastTalker;
	var curper=GetCurrentPerson();
	var tmpbox=g_Boxes.get(id);
	if(g_Boxes.open[id]){
		dialog.reset();
		dialog.think(attper,langmodule.getString("S_BOXEMPTY"));
		RenderMap();
		}
	else{
		SetPersonFrame(curper,1);
		var tmpinh=tmpbox.Inhalttyp.get(tmpbox.Inhaltnr);
		g_Boxes.open[id]=true;
		tmpinh.menge+=tmpbox.Menge;
		renderscript.add("BoxIcon","g_Boxes.get("+id+").Inhalttyp.get(g_Boxes.get("+id+").Inhaltnr).icon.blit(MapToScreenX(GetPersonLayer(\""+curper+"\"),GetPersonX(\""+curper+"\")-7),MapToScreenY(GetPersonLayer(\""+curper+"\"),GetPersonY(\""+curper+"\")-10-iconPos)); if(iconPos<36)iconPos++;");
	  FlashNote(tmpbox.Menge+"x "+tmpinh.name+" "+langmodule.getString("S_ERHALTEN")+".",CreateColor(255,200,100),1);
		renderscript.del("BoxIcon");
		iconPos=0;
		tmpbox.Inhalttyp.updateCache();
		}
	while(IsKeyPressed(btn_OK))MapDelay(1);
	personcontroller.lockAllInputProfile(false,undefined);
	}*/